<!-- Stored in resources/views/child.blade.php -->

<!-- Sidebar -->
<div class="sidebar sidebar-style-2" data-background-color="<?php echo e(Auth('admin')->User()->dashboard_style); ?>">
    <div class="sidebar-wrapper scrollbar scrollbar-inner">
        <div class="sidebar-content">
            <div class="user">
                <div class="info">
                    <a data-toggle="collapse" href="#collapseExample" aria-expanded="true">
                        <span>
                            <?php echo e(Auth('admin')->User()->firstName); ?> <?php echo e(Auth('admin')->User()->lastName); ?>

                            <span class="user-level"> Admin</span>
                            
                        </span>
                    </a>
                </div>
            </div>
           
            <ul class="nav nav-primary">
                <li class="nav-item <?php echo e((request()->routeIs('admin.dashboard')) ? 'active' : ''); ?>">
                    <a href="<?php echo e(url('/admin/dashboard')); ?>">
                        <i class="fas fa-home"></i>
                        <p>Dashboard</p>
                    </a>
                </li>
                <?php if(Auth('admin')->User()->type == "Super Admin" || Auth('admin')->User()->type == "Admin"): ?>
                    
                <li class="nav-item <?php echo e((request()->routeIs('plans')) ? 'active' : ''); ?> <?php echo e((request()->routeIs('newplan')) ? 'active' : ''); ?> <?php echo e((request()->routeIs('editplan')) ? 'active' : ''); ?>">
                    <a href="<?php echo e(url('/admin/dashboard/plans')); ?>">
                        <i class="fas fa-cubes " aria-hidden="true"></i>
                        <p>Investment Plans</p>
                    </a>
                </li>
                <li class="nav-item <?php echo e((request()->routeIs('manageusers')) ? 'active' : ''); ?> <?php echo e((request()->routeIs('loginactivity')) ? 'active' : ''); ?> <?php echo e((request()->routeIs('user.plans')) ? 'active' : ''); ?> <?php echo e((request()->routeIs('viewuser')) ? 'active' : ''); ?>">
                    <a href="<?php echo e(url('/admin/dashboard/manageusers')); ?>">
                        <i class="fa fa-user-circle" aria-hidden="true"></i>
                        <p>Manage Users</p>
                    </a>
                </li>
                
                <li class="nav-item <?php echo e((request()->routeIs('mdeposits')) ? 'active' : ''); ?> <?php echo e((request()->routeIs('mwithdrawals')) ? 'active' : ''); ?> <?php echo e((request()->routeIs('mdeposits')) ? 'active' : ''); ?> <?php echo e((request()->routeIs('viewdepositimage')) ? 'active' : ''); ?> <?php echo e((request()->routeIs('processwithdraw')) ? 'active' : ''); ?>">
                    <a data-toggle="collapse" href="#mdw">
                        <i class="fas fa-credit-card"></i>
                        <p>Manage D/W</p>
                        <span class="caret"></span>
                    </a>
                    <div class="collapse" id="mdw">
                        <ul class="nav nav-collapse">
                            <li>
                                <a href="<?php echo e(url('/admin/dashboard/mdeposits')); ?>">
                                    <span class="sub-item">Manage Deposit</span>
                                </a>
                            </li>
                            <li>
                                <a href="<?php echo e(url('/admin/dashboard/mwithdrawals')); ?>">
                                    <span class="sub-item">Manage Withdrawal</span>
                                </a>
                            </li>
                        </ul>
                    </div>
                </li>
                
                
                <?php if($settings->subscription_service == 'on'): ?>
                <li class="nav-item <?php echo e((request()->routeIs('subtrade')) ? 'active' : ''); ?>">
                    <a href="<?php echo e(url('/admin/dashboard/msubtrade')); ?>">
                        <i class="fa fa-sync-alt" aria-hidden="true"></i>
                        <p>Manage Subscription</p>
                    </a>
                </li>
                <?php endif; ?>
                <?php endif; ?>
                
                <?php if(Auth('admin')->User()->type == "Super Admin"): ?>
                   <li class="nav-item <?php echo e((request()->routeIs('addmanager')) ? 'active' : ''); ?> <?php echo e((request()->routeIs('madmin')) ? 'active' : ''); ?>">
                    <a data-toggle="collapse" href="#adm">
                        <i class="fa fa-user"></i>
                        <p>Administrator(s)</p>
                        <span class="caret"></span>
                    </a>
                    <div class="collapse" id="adm">
                        <ul class="nav nav-collapse">
                            <li>
                                <a href="<?php echo e(url('/admin/dashboard/addmanager')); ?>">
                                    <span class="sub-item">Add Manager</span>
                                </a>
                            </li>
                            <li>
                                <a href="<?php echo e(url('/admin/dashboard/madmin')); ?>">
                                    <span class="sub-item">Manage Administrator(s)</span>
                                </a>
                            </li>
                        </ul>
                    </div>
                </li> 
                
                <li class="nav-item <?php echo e((request()->routeIs('appsettingshow')) ? 'active' : ''); ?> <?php echo e((request()->routeIs('termspolicy')) ? 'active' : ''); ?> <?php echo e((request()->routeIs('refsetshow')) ? 'active' : ''); ?> <?php echo e((request()->routeIs('paymentview')) ? 'active' : ''); ?> <?php echo e((request()->routeIs('subview')) ? 'active' : ''); ?> <?php echo e((request()->routeIs('frontpage')) ? 'active' : ''); ?> <?php echo e((request()->routeIs('allipaddress')) ? 'active' : ''); ?> <?php echo e((request()->routeIs('ipaddress')) ? 'active' : ''); ?> <?php echo e((request()->routeIs('editpaymethod')) ? 'active' : ''); ?> <?php echo e((request()->routeIs('managecryptoasset')) ? 'active' : ''); ?>">
                    <a data-toggle="collapse" href="#settings">
                        <i class="fa fa-cog"></i>
                        <p>Settings</p>
                        <span class="caret"></span>
                    </a>
                    <div class="collapse" id="settings">
                        <ul class="nav nav-collapse">
                            <li>
                                <a href="<?php echo e(route('appsettingshow')); ?>">
                                    <span class="sub-item">App Settings</span>
                                </a>
                            </li>
                            <li>
                                <a href="<?php echo e(route('refsetshow')); ?>">
                                    <span class="sub-item">Referral Settings</span>
                                </a>
                            </li>
                            <li>
                                <a href="<?php echo e(route('paymentview')); ?>">
                                    <span class="sub-item">Payment Settings</span>
                                </a>
                            </li>
                            <li>
                                <a href="<?php echo e(route('managecryptoasset')); ?>">
                                    <span class="sub-item">Exchange Settings</span>
                                </a>
                            </li>
                            <li>
                                <a href="<?php echo e(route('subview')); ?>">
                                    <span class="sub-item">Subscription Settings</span>
                                </a>
                            </li>
                            <li>
                                <a href="<?php echo e(url('/admin/dashboard/frontpage')); ?>">
                                    <span class="sub-item">Frontend Settings</span>
                                </a>
                            </li>
                            <li>
                                <a href="<?php echo e(route('termspolicy')); ?>">
                                    <span class="sub-item">Terms and Privacy</span>
                                </a>
                            </li>
                            <li>
                                <a href="<?php echo e(url('/admin/dashboard/ipaddress')); ?>">
                                    <span class="sub-item">IP Address</span>
                                </a>
                            </li>
                        </ul>
                    </div>
                </li> 

                
                
                <?php endif; ?>
            </ul>
        </div>
    </div>
</div>
<!-- End Sidebar -->
<?php /**PATH /home/norwegia/app.plexassettrade.com/resources/views/admin/sidebar.blade.php ENDPATH**/ ?>